
$DoorOpenTime = 1;

$DoorWork = 0;
$DoorHome = 1;
$DoorHide = 2;
$DoorTarget = 3;



// HANDLES ALL DOOR OPENING FUNCTIONALITY
function OpenDoorEnter(%data, %doorType)
{
   // get the character entering the work building
   %object = GetThisObject(%data);
   %character = slgQueryInterface(%object, $CID_CHARACTER);
   if (isObject(%character) == false)
   {
      return;
   }
   
   // get the building for the character
   %building = 0;
   switch (%doorType)
   {
   case $DoorWork:
      %building = %character.getWork();
   case $DoorHome:
      %building = %character.getHome();
   case $DoorHide:
      %building = %character.getCover();
   case $DoorTarget:
      %building = GetParameterTarget(%data);
   }
   if (isObject(%building) == false)
   {
      return;
   }
   
   // check if the door needs to open and update the number of
   // times this door has been opened
   if (%building.doorOpenCount == 0)
   {
      %building.playThread(1, "opendoor");
   }
   %building.doorOpenCount++;
}

function OpenDoorUpdate(%data)
{
   %timePassed = TimeInNode(%data);
   if (%timePassed >= $DoorOpenTime)
   {
      ReturnValue(%data, 0);
   }
   else
   {
      ReturnValue(%data, -1);
   }
   return;
}



// HANDLES OPENING THE WORK DOOR
function AISMN_OpenWorkDoor::OnEnter(%this, %data)
{
   OpenDoorEnter(%data, $DoorWork);
}

function AISMN_OpenWorkDoor::Update(%this, %data)
{
   OpenDoorUpdate(%data);
}



// HANDLES OPENING THE HOME DOOR
function AISMN_OpenHomeDoor::OnEnter(%this, %data)
{
   OpenDoorEnter(%data, $DoorHome);
}

function AISMN_OpenHomeDoor::Update(%this, %data)
{
   OpenDoorUpdate(%data);
}



// HANDLES OPENING THE HIDE DOOR
function AISMN_OpenHideDoor::OnEnter(%this, %data)
{
   OpenDoorEnter(%data, $DoorHide);
}

function AISMN_OpenHideDoor::Update(%this, %data)
{
   OpenDoorUpdate(%data);
}



// HANDLES OPENING THE TARGET DOOR
function AISMN_OpenTargetDoor::OnEnter(%this, %data)
{
   OpenDoorEnter(%data, $DoorTarget);
}

function AISMN_OpenTargetDoor::Update(%this, %data)
{
   OpenDoorUpdate(%data);
}
